 aR  w Q mP9      h	 oP     nSystem-wide
; This is cp.constant.asm.inc
; This file contains the constants,
; structures, and macros used in the compass proms


; constants

TRUE           EQU 0ffh
FALSE          EQU 0
nullWord       EQU 0ffffh
nullByte       EQU 0ffh
systemPid      EQU 0           ; pid used by O.S.
asciiMode      EQU 0           ; caseless compare
binaryMode     EQU 1           ; case sensitive compare
memException   EQU 2           ; memory exception number


; multi-tasking constants


nullPtrLow     EQU 0fH
nullPtrHigh    EQU 0ffffH
nullProcessPid EQU 0fffeh
roundRobin     EQU 0ffffh
goodBye        EQU 0fffeh
signalled      EQU 0ffffh
semaphoreIdCode EQU 05a5bh
processIdCode  EQU 0a5b5h
initialFlagState EQU 0f246h
timeSlice      EQU 10         ; this can change

timedMask      EQU 0fh
snoozeSignalMask EQU 07fh     ; signal, but don't reschedule

readyState     EQU 0
timedWait      EQU 10h
messageWait    EQU 2
timedMessageWait EQU 12h
semaphoreWait  EQU 3
timedSemaphoreWait EQU 13h
loadedPackage  EQU 4
debugSuspendedState EQU 5


; errors

eOk            EQU 0           ; no error
eBadPointer    EQU 31          ; error if links are bad
eInvMemBlock   EQU 11          ; invalid memory block (never allocated)
eCheckSum      EQU 29          ; checksum error
eOutOfMem      EQU 2           ; out of memory
eProcNotExist  EQU 251         ; process does not exist
eSemaNotExist  EQU 252         ; semaphore does not exist
eTimeOut       EQU 253         ; timed out error
eTooManyMsgs   EQU 255         ; too many messages for the queue

; multi-tasking constants

signalNormal   EQU 1           ; do a normal signal


; structures

QcbType STRUC
    headOfQ DW ?
    tailOfQ DW ?
    usesChecksum DB ?
    qcbCount DW ?
    elementLength DW ?
QcbType ENDS


QElementType STRUC
    checkSum DW ?
    next DW ?
    prev DW ?
QElementType ENDS

nextOffset EQU 2

MemCbType STRUC
    mmcbFiller DW 3 DUP (?)
    mmcbNumBlk DW ?
    mmcbRemainder DW ?
    mmcbPid DW ?
MemcbType ENDS


MemStatusType STRUC
    freeBytes DD ?
    freeBlocks DW ?
    largestFree DW ?
    allocBytes DD ?
    allocBlocks DW ?
    largestAlloc DW ?
MemStatusType ENDS

freeBytesLow EQU 0
freeBytesHigh EQU 2
allocBytesOffset EQU 8

ScbType STRUC
    scbFiller DW 3 DUP (?)
    scbParentPid DW ?
    scbBusy DW ?
    scbNote DW ?
    scbIdCode DW ?
    scbCount DW ?
ScbType ENDS

McbType STRUC
    mcbFiller DW 3 DUP (?)
    mcbNote DW ?
    mcbMessageType DW ?
    mcbPMessageOff DW ?
    mcbPMessageSeg DW ?
    mcbSourceProcID DW ?
McbType ENDS

BirthMsgType STRUC
    bootCardID DB ?
    birthspare DB ?
    doSelfTest DB ?
BirthMsgType ENDS

ConfigAreaType STRUC
    spare1         DB 8 DUP (?)
    configCardType DW ?
    configCardVers DW ?
    configPromVers DB ?
    configMemSize  DB ?
    spare2         DB 2 DUP (?)
ConfigAreaType ENDS

ConsoleAreaType STRUC
    inStatus DB ?
    inData DB ?
    outStatus DB ?
    outData DB ?
    interruptMode DB ?
    consoleCardId DB ?
    ownerProcId DW ?
    overflow DB ?
    spare DB 7 DUP (?)
ConsoleAreaType ENDS

RegTableType STRUC
    regBp DW ?
    regKip DW ?
    regDs DW ?
    regEs DW ?
    regIp DW ?
    regCs DW ?
    regFl DW ?
RegTableType ENDS

PcbType STRUC
    pcbFiller DW 3 DUP (?)
    pcbMsgHeadOff DW ?
    pcbMsgHeadSeg DW ?
    pcbMsgTailOff DW ?
    pcbMsgTailSeg DW ?
    pcbMsgCount   DB ?
    pcbState      DB ?
; 16
    pcbPriority    DB ?
    pcbDebug       DB ?
    pcbPMessageOff DW ?
    pcbPMessageSeg DW ?
    pcbMessageType DW ?
    pcbNote DW ?
    pcbTimeLimit DW ?
    pcbStackOff DW ?
    pcbStackSeg DW ?
; 32
    pcbHeap DB 16 DUP (?)
; 48
    pcbSource DW ?
    pcbPLoadTable DD ?
    pcbPCliBuffer DD ?
    pcbCliOffset DW ?
    pcbPAbortRoutine DD ?
    pcbPErrorOff DW ?
    pcbPErrorSeg DW ?
    pcbTrapCancel DB ?
    pcbParentPid DW ?
    pcbIdCode DW ?
    pcbUses8087 DB ?
    pcbP8087Regs DD ?
    pcbPWindow DD ?
    pcbVersion DB 3 DUP (?)
    pcbProcID DW ?
    pcbExtraByte DB ?
    pcbExtraWord DW ?
PcbType ENDS

pcbMsgOverlayOffset EQU 4

MsgType STRUC
    msgIpcFuncCode  DB ?
    msgDeleteSource DB ?
    msgLink         DD ?
    msgSource       DW ?
    msgDest         DW ?
    msgClass        DW ?
    msgNote         DW ?
    msgLength       DW ?
MsgType ENDS

; interrupt ID's

int8087       EQU 0
intGpib       EQU 1
intKeyboard   EQU 2  ; (Never used on CCCOS)
intSysTick    EQU 3  ; (intVertSync on compass)
intModem      EQU 4
intBubble     EQU 5  ; (Never used on CCCOS)
intSerial     EQU 6
intRing       EQU 7
intMessage    EQU 8
intAlarm      EQU 9
intDma0       EQU 10 ; Periperhal Bus DMA for FS
intDma1       EQU 11 ; GPIB Bus DMA for FS
intPerBus     EQU 12
intBusTerm    EQU 13
intPerTimeOut EQU 14

; glitch interrupt value

intGlitch        EQU 7

; message passing

msgIntReset  EQU 0180H
commonRamSeg EQU 08000H
intr8051Port EQU 0E000H
